/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.ApprovingObject;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SurgeToVictoryCastEffect
extends OneShotEffect {
    private final MageObjectReference mor;

    SurgeToVictoryCastEffect(Card card, Game game) {
        super(Outcome.Benefit);
        this.mor = new MageObjectReference((MageObject)card, game);
    }

    private SurgeToVictoryCastEffect(SurgeToVictoryCastEffect effect) {
        super((OneShotEffect)effect);
        this.mor = effect.mor;
    }

    public SurgeToVictoryCastEffect copy() {
        return new SurgeToVictoryCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = this.mor.getCard(game);
        if (player == null || card == null) {
            return false;
        }
        Card copiedCard = game.copyCard(card, source, player.getId());
        if (copiedCard == null) {
            return false;
        }
        if (!player.chooseUse(this.outcome, "Cast the copy of the exiled card?", source, game)) {
            return false;
        }
        game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), (Object)Boolean.TRUE);
        player.cast(player.chooseAbilityForCast(copiedCard, game, true), game, true, new ApprovingObject(source, game));
        game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), null);
        return true;
    }
}

