/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

class SurrakElusiveHunterTriggeredAbility
extends TriggeredAbilityImpl {
    SurrakElusiveHunterTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1));
        this.setTriggerPhrase("Whenever a creature you control or a creature spell you control becomes the target of a spell or ability an opponent controls, ");
    }

    private SurrakElusiveHunterTriggeredAbility(SurrakElusiveHunterTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SurrakElusiveHunterTriggeredAbility copy() {
        return new SurrakElusiveHunterTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TARGETED;
    }

    private boolean checkTargeted(UUID targetId, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(targetId);
        if (permanent != null) {
            return permanent.isCreature(game) && permanent.isControlledBy(this.getControllerId());
        }
        Spell spell = game.getSpellOrLKIStack(targetId);
        return spell != null && spell.isCreature(game) && spell.isControlledBy(this.getControllerId());
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.checkTargeted(event.getTargetId(), game)) {
            return false;
        }
        StackObject targetingObject = game.findTargetingStackObject(this.getId().toString(), event);
        return targetingObject != null && game.getOpponents(this.getControllerId()).contains(targetingObject.getControllerId());
    }
}

