/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.PreventionEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.command.CommandObject;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;

class SwansOfBrynArgollEffect
extends PreventionEffectImpl {
    SwansOfBrynArgollEffect() {
        super(Duration.WhileOnBattlefield, Integer.MAX_VALUE, false, false);
        this.staticText = "If a source would deal damage to {this}, prevent that damage. The source's controller draws cards equal to the damage prevented this way";
    }

    private SwansOfBrynArgollEffect(SwansOfBrynArgollEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        PreventionEffectData preventionEffectData = this.preventDamageAction(event, source, game);
        if (preventionEffectData.getPreventedDamage() > 0) {
            boolean passed = false;
            MageObject sourceOfDamage = game.getObject(event.getSourceId());
            if (sourceOfDamage != null) {
                Player owner;
                Card cardSource;
                Player controllerOfPermanent;
                Player controllerOfSpell;
                Spell spell = game.getStack().getSpell(sourceOfDamage.getId());
                Permanent permanent = game.getPermanentOrLKIBattlefield(sourceOfDamage.getId());
                CommandObject emblem = (CommandObject)game.getEmblem(sourceOfDamage.getId());
                if (spell != null && (controllerOfSpell = game.getPlayer(spell.getControllerId())) != null) {
                    controllerOfSpell.drawCards(preventionEffectData.getPreventedDamage(), source, game);
                    passed = true;
                }
                if (permanent != null && (controllerOfPermanent = game.getPlayer(permanent.getControllerId())) != null) {
                    controllerOfPermanent.drawCards(preventionEffectData.getPreventedDamage(), source, game);
                    passed = true;
                }
                if (emblem != null) {
                    Player controllerOfEmblem = game.getPlayer(emblem.getControllerId());
                    if (controllerOfEmblem != null) {
                        controllerOfEmblem.drawCards(preventionEffectData.getPreventedDamage(), source, game);
                    }
                    passed = true;
                }
                if (!passed && (cardSource = game.getCard(event.getSourceId())) != null && (owner = game.getPlayer(cardSource.getOwnerId())) != null) {
                    owner.drawCards(preventionEffectData.getPreventedDamage(), source, game);
                }
            }
        }
        return preventionEffectData.isReplaced();
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT && event.getTargetId().equals(source.getSourceId());
    }

    public SwansOfBrynArgollEffect copy() {
        return new SwansOfBrynArgollEffect(this);
    }
}

