/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

class SwashbucklerExtraordinaireEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.TREASURE, "Treasures");

    SwashbucklerExtraordinaireEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice one or more Treasures. When you do, up to that many target creatures gain double strike until end of turn";
    }

    private SwashbucklerExtraordinaireEffect(SwashbucklerExtraordinaireEffect effect) {
        super((OneShotEffect)effect);
    }

    public SwashbucklerExtraordinaireEffect copy() {
        return new SwashbucklerExtraordinaireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        Set treasures = target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (treasures.isEmpty()) {
            return false;
        }
        for (Permanent permanent : treasures) {
            permanent.sacrifice(source, game);
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new GainAbilityTargetEffect((Ability)DoubleStrikeAbility.getInstance()), false, "up to that many target creatures gain double strike until end of turn");
        ability.addTarget((Target)new TargetCreaturePermanent(0, treasures.size()));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

