/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PutOnLibraryTargetEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SweepAwayEffect
extends OneShotEffect {
    SweepAwayEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return target creature to its owner's hand. If that creature is attacking, you may put it on top of its owner's library instead";
    }

    private SweepAwayEffect(SweepAwayEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && controller != null) {
            if (permanent.isAttacking()) {
                if (controller.chooseUse(Outcome.Neutral, "Put " + permanent.getIdName() + " on top of its owner's library (otherwise return to hand)?", source, game)) {
                    new PutOnLibraryTargetEffect(true).apply(game, source);
                } else {
                    new ReturnToHandTargetEffect().apply(game, source);
                }
            } else {
                new ReturnToHandTargetEffect().apply(game, source);
            }
            return true;
        }
        return false;
    }

    public SweepAwayEffect copy() {
        return new SweepAwayEffect(this);
    }
}

