/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.CrewAbility;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SwiftReconfigurationEffect
extends ContinuousEffectImpl {
    SwiftReconfigurationEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "enchanted permanent is a Vehicle artifact with crew 5 and it loses all other card types";
    }

    private SwiftReconfigurationEffect(SwiftReconfigurationEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public SwiftReconfigurationEffect copy() {
        return new SwiftReconfigurationEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent aura = source.getSourcePermanentIfItStillExists(game);
        if (aura == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(aura.getAttachedTo());
        if (permanent == null) {
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.removeAllCardTypes(game);
                permanent.addCardType(game, new CardType[]{CardType.ARTIFACT});
                permanent.addSubType(game, new SubType[]{SubType.VEHICLE});
                return true;
            }
            case AbilityAddingRemovingEffects_6: {
                permanent.addAbility((Ability)new CrewAbility(5), source.getSourceId(), game);
                return true;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.AbilityAddingRemovingEffects_6;
    }
}

