/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.LinkedList;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class SwiftSilenceEffect
extends OneShotEffect {
    SwiftSilenceEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter all other spells. Draw a card for each spell countered this way.";
    }

    private SwiftSilenceEffect(SwiftSilenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        LinkedList<Spell> spellsToCounter = new LinkedList<Spell>();
        for (Object stackObject : game.getStack()) {
            if (!(stackObject instanceof Spell) || stackObject.getId().equals(source.getSourceObject(game).getId())) continue;
            spellsToCounter.add((Spell)stackObject);
        }
        int toDraw = 0;
        for (Spell spell : spellsToCounter) {
            if (!game.getStack().counter(spell.getId(), source, game)) continue;
            ++toDraw;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (toDraw > 0 && controller != null) {
            controller.drawCards(toDraw, source, game);
        }
        return true;
    }

    public SwiftSilenceEffect copy() {
        return new SwiftSilenceEffect(this);
    }
}

