/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CounterTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Library;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class SwindlersSchemeEffect
extends OneShotEffect {
    SwindlersSchemeEffect() {
        super(Outcome.Detriment);
        this.staticText = "reveal the top card of your library. If it shares a card type with that spell, counter that spell and that opponent may cast the revealed card without paying its mana cost.";
    }

    private SwindlersSchemeEffect(SwindlersSchemeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Spell spell = (Spell)this.getValue("spellCast");
        Library library = controller.getLibrary();
        Card cardFromTop = library.getFromTop(game);
        if (cardFromTop == null) {
            return false;
        }
        if (cardFromTop.getCardType(game).stream().noneMatch(spell.getCardType(game)::contains)) {
            return false;
        }
        Player opponent = game.getPlayer(spell.getControllerId());
        CounterTargetEffect counterEffect = new CounterTargetEffect();
        counterEffect.setTargetPointer((TargetPointer)new FixedTarget(spell.getId()));
        counterEffect.apply(game, source);
        CardUtil.castSpellWithAttributesForFree((Player)opponent, (Ability)source, (Game)game, (Card)cardFromTop);
        return true;
    }

    public SwindlersSchemeEffect copy() {
        return new SwindlersSchemeEffect(this);
    }
}

