/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class SwordswornCavalierWatcher
extends Watcher {
    private final Map<UUID, Set<MageObjectReference>> map = new HashMap<UUID, Set<MageObjectReference>>();

    SwordswornCavalierWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ENTERS_THE_BATTLEFIELD) {
            return;
        }
        Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
        if (permanent.hasSubtype(SubType.KNIGHT, game)) {
            this.map.computeIfAbsent(permanent.getControllerId(), x -> new HashSet()).add(new MageObjectReference((MageObject)permanent, game));
        }
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    static boolean checkPermanent(Game game, Ability source) {
        return ((SwordswornCavalierWatcher)game.getState().getWatcher(SwordswornCavalierWatcher.class)).map.getOrDefault(source.getControllerId(), Collections.emptySet()).stream().anyMatch(mor -> !mor.refersTo(source, game));
    }
}

