/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.common.FilterLandCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCardInLibrary;

class SylvanPrimordialEffect
extends OneShotEffect {
    private static final FilterLandCard filterForest = new FilterLandCard("Forest");

    public SylvanPrimordialEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "for each opponent, destroy target noncreature permanent that player controls. For each permanent destroyed this way, search your library for a Forest card and put that card onto the battlefield tapped. Then shuffle";
    }

    private SylvanPrimordialEffect(SylvanPrimordialEffect effect) {
        super((OneShotEffect)effect);
    }

    public SylvanPrimordialEffect copy() {
        return new SylvanPrimordialEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean result = false;
        int destroyedCreatures = 0;
        for (Target target : source.getTargets()) {
            Permanent targetPermanent;
            if (!(target instanceof TargetPermanent) || (targetPermanent = game.getPermanent(target.getFirstTarget())) == null || !targetPermanent.destroy(source, game, false)) continue;
            ++destroyedCreatures;
        }
        if (destroyedCreatures > 0) {
            new SearchLibraryPutInPlayEffect(new TargetCardInLibrary(destroyedCreatures, (FilterCard)filterForest), true).apply(game, source);
        }
        return result;
    }

    static {
        filterForest.add((Predicate)SubType.FOREST.getPredicate());
    }
}

