/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class SynodSanctumEffect
extends OneShotEffect {
    SynodSanctumEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile target permanent you control";
    }

    private SynodSanctumEffect(SynodSanctumEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            UUID exileZone;
            Permanent permanent;
            if (this.getTargetPointer().getFirst(game, source) != null && (permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null && (exileZone = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC())) != null) {
                controller.moveCardToExileWithInfo((Card)permanent, exileZone, sourceObject.getIdName(), source, game, Zone.BATTLEFIELD, true);
            }
            return true;
        }
        return false;
    }

    public SynodSanctumEffect copy() {
        return new SynodSanctumEffect(this);
    }
}

