/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.s.SyntheticDestinyDelayedEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class SyntheticDestinyEffect
extends OneShotEffect {
    SyntheticDestinyEffect() {
        super(Outcome.Detriment);
        this.staticText = "Exile all creatures you control. At the beginning of the next end step, reveal cards from the top of your library until you reveal that many creature cards, put all creature cards revealed this way onto the battlefield, then shuffle the rest of the revealed cards into your library";
    }

    private SyntheticDestinyEffect(SyntheticDestinyEffect effect) {
        super((OneShotEffect)effect);
    }

    public SyntheticDestinyEffect copy() {
        return new SyntheticDestinyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashSet cardsToExile = new HashSet();
            cardsToExile.addAll(game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, controller.getId(), game));
            controller.moveCards(cardsToExile, Zone.EXILED, source, game);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new SyntheticDestinyDelayedEffect(cardsToExile.size())), source);
            return true;
        }
        return false;
    }
}

