/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class TargetTwoNonLandCardsWithSameNameInHand
extends TargetCardInHand {
    public TargetTwoNonLandCardsWithSameNameInHand() {
        super(2, 2, (FilterCard)new FilterNonlandCard("nonland cards with the same name"));
    }

    private TargetTwoNonLandCardsWithSameNameInHand(TargetTwoNonLandCardsWithSameNameInHand target) {
        super((TargetCardInHand)target);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        Player player = game.getPlayer(sourceControllerId);
        if (player == null) {
            return possibleTargets;
        }
        CardsImpl cardsToCheck = new CardsImpl(player.getHand().getCards(this.filter, game));
        if (this.targets.size() == 1) {
            for (Map.Entry entry : this.targets.entrySet()) {
                Card chosenCard = cardsToCheck.get((UUID)entry.getKey(), game);
                if (chosenCard == null) continue;
                for (UUID cardToCheck : cardsToCheck) {
                    if (cardToCheck.equals(chosenCard.getId()) || !chosenCard.getName().equals(game.getCard(cardToCheck).getName())) continue;
                    possibleTargets.add(cardToCheck);
                }
            }
        } else {
            for (UUID cardToCheck : cardsToCheck) {
                Card card = game.getCard(cardToCheck);
                if (card == null) continue;
                String nameToSearch = CardUtil.getCardNameForSameNameSearch((Card)card);
                FilterCard nameFilter = new FilterCard();
                nameFilter.add((Predicate)new NamePredicate(nameToSearch));
                if (cardsToCheck.count(nameFilter, game) <= 1) continue;
                possibleTargets.add(cardToCheck);
            }
        }
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    public TargetTwoNonLandCardsWithSameNameInHand copy() {
        return new TargetTwoNonLandCardsWithSameNameInHand(this);
    }
}

