/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Iterator;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class UnboostCreaturesTargetPlayerEffect
extends ContinuousEffectImpl {
    private final int power;
    private final int toughness;

    public UnboostCreaturesTargetPlayerEffect(int power, int toughness) {
        super(Duration.EndOfTurn, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.power = power;
        this.toughness = toughness;
        this.staticText = "creatures defending player controls get -1/-1 until end of turn";
    }

    private UnboostCreaturesTargetPlayerEffect(UnboostCreaturesTargetPlayerEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.power = effect.power;
        this.toughness = effect.toughness;
    }

    public UnboostCreaturesTargetPlayerEffect copy() {
        return new UnboostCreaturesTargetPlayerEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.getAffectedObjectsSet()) {
            for (Permanent creature : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, this.getTargetPointer().getFirst(game, source), game)) {
                this.affectedObjectList.add(new MageObjectReference((MageObject)creature, game));
            }
        }
    }

    public boolean apply(Game game, Ability source) {
        Iterator it = this.affectedObjectList.iterator();
        while (it.hasNext()) {
            Permanent permanent = ((MageObjectReference)it.next()).getPermanent(game);
            if (permanent != null) {
                permanent.addPower(this.power);
                permanent.addToughness(this.toughness);
                continue;
            }
            it.remove();
        }
        return true;
    }
}

