/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.util.SubTypes;

class AddCardSubTypeEnteringTargetEffect
extends ContinuousEffectImpl {
    private final SubType addedSubType;
    private final MageObjectReference mor;
    private Card card;

    AddCardSubTypeEnteringTargetEffect(MageObjectReference mor, SubType addedSubType, Duration duration) {
        super(duration, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.addedSubType = addedSubType;
        this.mor = mor;
    }

    protected AddCardSubTypeEnteringTargetEffect(AddCardSubTypeEnteringTargetEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.addedSubType = effect.addedSubType;
        this.mor = effect.mor;
        this.card = effect.card;
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpell(this.getTargetPointer().getFirst(game, source));
        MageObject target = game.getObject(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            this.card = spell.getCard();
        }
        for (StackObject stackObject : game.getStack()) {
            if (!(stackObject instanceof Spell) || target == null || !target.equals(stackObject) || !this.mor.refersTo(target, game)) continue;
            this.setCreatureSubtype((MageObject)stackObject, this.addedSubType, game);
            this.setCreatureSubtype((MageObject)((Spell)stackObject).getCard(), this.addedSubType, game);
        }
        if (this.card != null && game.getPermanent(this.card.getId()) != null && game.getState().getZoneChangeCounter(this.card.getId()) == this.mor.getZoneChangeCounter() + 1) {
            game.getPermanent(this.card.getId()).addSubType(game, new SubType[]{this.addedSubType});
        }
        return true;
    }

    private void setCreatureSubtype(MageObject object, SubType subtype, Game game) {
        SubTypes subTypes = game.getState().getCreateMageObjectAttribute(object, game).getSubtype();
        if (!subTypes.contains((Object)subtype)) {
            subTypes.add((Object)subtype);
        }
    }

    public AddCardSubTypeEnteringTargetEffect copy() {
        return new AddCardSubTypeEnteringTargetEffect(this);
    }
}

