/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TIEInterceptorEffect
extends OneShotEffect {
    TIEInterceptorEffect() {
        super(Outcome.Damage);
        this.staticText = "each opponent loses 2 life";
    }

    private TIEInterceptorEffect(TIEInterceptorEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null) continue;
            opponent.loseLife(2, game, source, false);
        }
        return true;
    }

    public TIEInterceptorEffect copy() {
        return new TIEInterceptorEffect(this);
    }
}

