/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class TabletOfTheGuildsGainLifeEffect
extends OneShotEffect {
    TabletOfTheGuildsGainLifeEffect() {
        super(Outcome.Neutral);
        this.staticText = "if it's at least one of the chosen colors, you gain 1 life for each of the chosen colors it is";
    }

    private TabletOfTheGuildsGainLifeEffect(TabletOfTheGuildsGainLifeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell;
        Player you = game.getPlayer(source.getControllerId());
        if (you != null && (spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source))) != null) {
            ObjectColor color1 = new ObjectColor((String)game.getState().getValue(source.getSourceId() + "_color1"));
            ObjectColor color2 = new ObjectColor((String)game.getState().getValue(source.getSourceId() + "_color2"));
            int amount = 0;
            if (spell.getColor(game).contains(color1)) {
                ++amount;
            }
            if (spell.getColor(game).contains(color2)) {
                ++amount;
            }
            if (amount > 0) {
                you.gainLife(amount, game, source);
                return true;
            }
        }
        return false;
    }

    public TabletOfTheGuildsGainLifeEffect copy() {
        return new TabletOfTheGuildsGainLifeEffect(this);
    }
}

