/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TaboraxHopesDemiseEffect
extends OneShotEffect {
    TaboraxHopesDemiseEffect() {
        super(Outcome.Benefit);
        this.staticText = "If that creature was a Cleric, you may draw a card. If you do, you lose 1 life.";
    }

    private TaboraxHopesDemiseEffect(TaboraxHopesDemiseEffect effect) {
        super((OneShotEffect)effect);
    }

    public TaboraxHopesDemiseEffect copy() {
        return new TaboraxHopesDemiseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent == null || !permanent.hasSubtype(SubType.CLERIC, game)) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player != null && player.chooseUse(this.outcome, "Draw a card and lose 1 life?", source, game) && player.drawCards(1, source, game) > 0) {
            player.loseLife(1, game, source, false);
            return true;
        }
        return false;
    }
}

