/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TajuruPreserverEffect
extends ReplacementEffectImpl {
    TajuruPreserverEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Spells and abilities your opponents control can't cause you to sacrifice permanents";
    }

    private TajuruPreserverEffect(TajuruPreserverEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TajuruPreserverEffect copy() {
        return new TajuruPreserverEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SACRIFICE_PERMANENT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        UUID eventSourceControllerId = game.getControllerId(event.getSourceId());
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (controller != null && permanent != null && permanent.getControllerId() == source.getControllerId()) {
            return game.getOpponents(source.getControllerId()).contains(eventSourceControllerId);
        }
        return false;
    }
}

