/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Iterator;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.keyword.BushidoAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TakenoSamuraiGeneralEffect
extends ContinuousEffectImpl {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();

    TakenoSamuraiGeneralEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "Each other Samurai creature you control gets +1/+1 for each point of bushido it has";
    }

    private TakenoSamuraiGeneralEffect(TakenoSamuraiGeneralEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TakenoSamuraiGeneralEffect copy() {
        return new TakenoSamuraiGeneralEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.getAffectedObjectsSet()) {
            for (Permanent perm : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
                if (perm.getId().equals(source.getSourceId())) continue;
                for (Ability ability : perm.getAbilities()) {
                    if (!(ability instanceof BushidoAbility)) continue;
                    this.affectedObjectList.add(new MageObjectReference((MageObject)perm, game));
                }
            }
        }
    }

    public boolean apply(Game game, Ability source) {
        if (this.getAffectedObjectsSet()) {
            Iterator it = this.affectedObjectList.iterator();
            while (it.hasNext()) {
                Permanent permanent = ((MageObjectReference)it.next()).getPermanent(game);
                if (permanent != null) {
                    for (Ability ability : permanent.getAbilities()) {
                        if (!(ability instanceof BushidoAbility)) continue;
                        int value = ((BushidoAbility)ability).getValue(source, game, (Effect)this);
                        permanent.addPower(value);
                        permanent.addToughness(value);
                    }
                    continue;
                }
                it.remove();
            }
        } else {
            for (Permanent perm : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
                if (perm.getId().equals(source.getSourceId())) continue;
                for (Ability ability : perm.getAbilities()) {
                    if (!(ability instanceof BushidoAbility)) continue;
                    int value = ((BushidoAbility)ability).getValue(source, game, (Effect)this);
                    perm.addPower(value);
                    perm.addToughness(value);
                }
            }
        }
        return true;
    }

    static {
        filter.add((Predicate)SubType.SAMURAI.getPredicate());
    }
}

