/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class TalarasBattalionWatcher
extends Watcher {
    private final Set<UUID> playerSet = new HashSet<UUID>();

    TalarasBattalionWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getSpell(event.getSourceId());
        if (spell != null && spell.getColor(game).isGreen()) {
            this.playerSet.add(spell.getControllerId());
        }
    }

    public void reset() {
        super.reset();
        this.playerSet.clear();
    }

    static boolean checkSpell(Game game, Ability source) {
        return ((TalarasBattalionWatcher)game.getState().getWatcher(TalarasBattalionWatcher.class)).playerSet.contains(source.getControllerId());
    }
}

