/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.VariableCostImpl;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.common.RemoveCountersSourceCost;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class TalonOfPainRemoveVariableCountersSourceCost
extends VariableCostImpl {
    protected int minimalCountersToPay = 0;
    private final String counterName;

    public TalonOfPainRemoveVariableCountersSourceCost(Counter counter) {
        this(counter, 0);
    }

    public TalonOfPainRemoveVariableCountersSourceCost(Counter counter, String text) {
        this(counter, 0, text);
    }

    public TalonOfPainRemoveVariableCountersSourceCost(Counter counter, int minimalCountersToPay) {
        this(counter, minimalCountersToPay, "");
    }

    public TalonOfPainRemoveVariableCountersSourceCost(Counter counter, int minimalCountersToPay, String text) {
        super(VariableCostType.NORMAL, counter.getName() + " counters to remove");
        this.minimalCountersToPay = minimalCountersToPay;
        this.counterName = counter.getName();
        this.text = text == null || text.isEmpty() ? "Remove X " + this.counterName + " counters from {this}" : text;
    }

    private TalonOfPainRemoveVariableCountersSourceCost(TalonOfPainRemoveVariableCountersSourceCost cost) {
        super((VariableCostImpl)cost);
        this.minimalCountersToPay = cost.minimalCountersToPay;
        this.counterName = cost.counterName;
    }

    public TalonOfPainRemoveVariableCountersSourceCost copy() {
        return new TalonOfPainRemoveVariableCountersSourceCost(this);
    }

    public Cost getFixedCostsFromAnnouncedValue(int xValue) {
        return new RemoveCountersSourceCost(new Counter(this.counterName, xValue));
    }

    public int getMinValue(Ability source, Game game) {
        return this.minimalCountersToPay;
    }

    public int getMaxValue(Ability source, Game game) {
        int maxValue = 0;
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            maxValue = permanent.getCounters(game).getCount(this.counterName);
        }
        return maxValue;
    }

    public int announceXValue(Ability source, Game game) {
        return (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
    }
}

