/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TalusPaladinEffect
extends OneShotEffect {
    public TalusPaladinEffect() {
        super(Outcome.Benefit);
    }

    private TalusPaladinEffect(TalusPaladinEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent taluspPaladin = game.getPermanent(source.getSourceId());
        if (taluspPaladin != null && player != null) {
            String question = "Put a +1/+1 counter on Talus Paladin?";
            if (!player.chooseUse(Outcome.Benefit, question, source, game)) {
                return false;
            }
            taluspPaladin.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
        }
        return false;
    }

    public TalusPaladinEffect copy() {
        return new TalusPaladinEffect(this);
    }
}

