/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class TangleWireEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("untapped artifact, creature, or land they control");

    TangleWireEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "that player taps an untapped artifact, creature, or land they control for each fade counter on {this}";
    }

    private TangleWireEffect(TangleWireEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (player == null || permanent == null) {
            return false;
        }
        int targetCount = game.getBattlefield().countAll((FilterPermanent)filter, player.getId(), game);
        int counterCount = permanent.getCounters(game).getCount(CounterType.FADE);
        int amount = Math.min(counterCount, targetCount);
        TargetControlledPermanent target = new TargetControlledPermanent(amount, amount, filter, true);
        target.withNotTarget(true);
        if (amount > 0 && player.chooseTarget(Outcome.Tap, (Target)target, source, game)) {
            boolean abilityApplied = false;
            for (UUID uuid : target.getTargets()) {
                Permanent selectedPermanent = game.getPermanent(uuid);
                if (selectedPermanent == null) continue;
                abilityApplied |= selectedPermanent.tap(source, game);
            }
            return abilityApplied;
        }
        return false;
    }

    public TangleWireEffect copy() {
        return new TangleWireEffect(this);
    }

    static {
        filter.add((Predicate)TappedPredicate.UNTAPPED);
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.LAND.getPredicate()}));
    }
}

