/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashMap;
import java.util.Map;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class TangledColonyWatcher
extends Watcher {
    private Map<MageObjectReference, Integer> damageMap = new HashMap<MageObjectReference, Integer>();

    TangledColonyWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_PERMANENT) {
            return;
        }
        Permanent damaged = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (damaged == null) {
            return;
        }
        MageObjectReference mor = new MageObjectReference((MageObject)damaged, game);
        this.damageMap.compute(mor, (mor_, i) -> i == null ? event.getAmount() : Integer.sum(i, event.getAmount()));
    }

    public void reset() {
        super.reset();
        this.damageMap.clear();
    }

    public Integer getDamage(MageObjectReference mor) {
        return this.damageMap.getOrDefault(mor, 0);
    }
}

