/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TangletroveKelpEffect
extends ContinuousEffectImpl {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("other Clues you control");

    TangletroveKelpEffect() {
        super(Duration.EndOfTurn, Outcome.BecomeCreature);
        this.staticText = "other Clues you control become 6/6 Plant creatures in addition to their other types until end of turn";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private TangletroveKelpEffect(TangletroveKelpEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TangletroveKelpEffect copy() {
        return new TangletroveKelpEffect(this);
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.PTChangingEffects_7;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        for (Permanent clue : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
            switch (layer) {
                case TypeChangingEffects_4: {
                    clue.addCardType(game, new CardType[]{CardType.CREATURE});
                    clue.addSubType(game, new SubType[]{SubType.PLANT});
                    break;
                }
                case PTChangingEffects_7: {
                    clue.getToughness().setModifiedBaseValue(6);
                    clue.getPower().setModifiedBaseValue(6);
                }
            }
        }
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filter.add((Predicate)SubType.CLUE.getPredicate());
    }
}

