/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.players.PlayerList;
import mage.target.TargetCard;

class TariffEffect
extends OneShotEffect {
    TariffEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Each player sacrifices the creature they control with the highest mana value unless they pay that creature's mana cost. If two or more creatures a player controls are tied for highest, that player chooses one.";
    }

    private TariffEffect(TariffEffect effect) {
        super((OneShotEffect)effect);
    }

    public TariffEffect copy() {
        return new TariffEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        PlayerList playerList = game.getPlayerList().copy();
        playerList.setCurrent((Object)game.getActivePlayerId());
        Player player = game.getPlayer(game.getActivePlayerId());
        do {
            this.processPlayer(game, source, player);
        } while ((player = playerList.getNext(game, false)) != null && !player.getId().equals(game.getActivePlayerId()));
        return true;
    }

    private void processPlayer(Game game, Ability source, Player player) {
        MageObject sourceObject = game.getObject(source);
        List<Permanent> creatures = this.getPermanentsWithTheHighestCMC(game, player.getId(), (FilterPermanent)new FilterControlledCreaturePermanent());
        Permanent creatureToPayFor = this.chooseOnePermanent(player, creatures, source, game);
        if (creatureToPayFor != null && sourceObject != null) {
            ManaCosts manaCost = ManaCosts.removeVariableManaCost((ManaCosts)creatureToPayFor.getManaCost());
            String message = "Pay " + manaCost.getText() + " (otherwise sacrifice " + creatureToPayFor.getName() + ")?";
            if (player.chooseUse(Outcome.Benefit, message, source, game) && manaCost.pay(source, game, source, player.getId(), false, null)) {
                game.informPlayers(sourceObject.getName() + ": " + player.getLogName() + " has paid");
                return;
            }
            game.informPlayers(sourceObject.getName() + ": " + player.getLogName() + " hasn't paid");
            creatureToPayFor.sacrifice(source, game);
        }
    }

    private List<Permanent> getPermanentsWithTheHighestCMC(Game game, UUID playerId, FilterPermanent filter) {
        List permanents = game.getBattlefield().getAllActivePermanents(filter, playerId, game);
        int highestCMC = -1;
        for (Permanent permanent : permanents) {
            if (highestCMC >= permanent.getManaValue()) continue;
            highestCMC = permanent.getManaValue();
        }
        ArrayList<Permanent> result = new ArrayList<Permanent>();
        for (Permanent permanent : permanents) {
            if (permanent.getManaValue() != highestCMC) continue;
            result.add(permanent);
        }
        return result;
    }

    private Permanent chooseOnePermanent(Player player, List<Permanent> permanents, Ability source, Game game) {
        Permanent permanent = null;
        if (permanents.size() == 1) {
            permanent = permanents.iterator().next();
        } else if (permanents.size() > 1) {
            CardsImpl cards = new CardsImpl();
            for (Permanent card : permanents) {
                cards.add((Card)card);
            }
            TargetCard targetCard = new TargetCard(Zone.BATTLEFIELD, new FilterCard());
            if (player.choose(Outcome.Benefit, (Cards)cards, targetCard, source, game)) {
                permanent = game.getPermanent(targetCard.getFirstTarget());
            }
        }
        return permanent;
    }
}

