/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class TashasHideousLaughterEffect
extends OneShotEffect {
    TashasHideousLaughterEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent exiles cards from the top of their library until that player has exiled cards with total mana value 20 or more";
    }

    private TashasHideousLaughterEffect(TashasHideousLaughterEffect effect) {
        super((OneShotEffect)effect);
    }

    public TashasHideousLaughterEffect copy() {
        return new TashasHideousLaughterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        block0: for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            int totalMV = 0;
            for (Card card : player.getLibrary().getCards(game)) {
                cards.add(card);
                if ((totalMV += card.getManaValue()) < 20) continue;
                continue block0;
            }
        }
        return controller.moveCards((Cards)cards, Zone.EXILED, source, game);
    }
}

