/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.Counters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class TawnossCoffinReturnEffect
extends OneShotEffect {
    TawnossCoffinReturnEffect() {
        super(Outcome.Neutral);
        this.staticText = "return the exiled card to the battlefield under its owner's control tapped with the noted number and kind of counters on it. If you do, return the exiled Aura cards to the battlefield under their owner's control attached to that permanent";
    }

    private TawnossCoffinReturnEffect(TawnossCoffinReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public TawnossCoffinReturnEffect copy() {
        return new TawnossCoffinReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        UUID exileZoneId = CardUtil.getCardExileZoneId((Game)game, (UUID)source.getSourceId(), (source.getSourcePermanentIfItStillExists(game) == null ? 1 : 0) != 0);
        ExileZone exileZone = game.getExile().getExileZone(exileZoneId);
        if (exileZone == null) {
            return true;
        }
        List exiledKeys = (List)game.getState().getValue(exileZoneId.toString() + "ExiledKeys");
        if (exiledKeys == null || exiledKeys.isEmpty()) {
            return true;
        }
        for (String uniqueKey : exiledKeys) {
            Map creatureToAurasMap;
            List auraIds;
            Card creatureCard;
            UUID creatureId;
            Map exileData = (Map)game.getState().getValue(uniqueKey);
            if (exileData == null || (creatureId = (UUID)exileData.get("Creature")) == null || !exileZone.contains((Object)creatureId) || (creatureCard = game.getCard(creatureId)) == null) continue;
            controller.moveCards(creatureCard, Zone.BATTLEFIELD, source, game, false, false, true, null);
            Permanent newPermanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)creatureCard, (Game)game);
            if (newPermanent == null) continue;
            Counters notedCounters = (Counters)exileData.get("NotedCounters");
            if (notedCounters != null) {
                for (Counter c : notedCounters.values()) {
                    if (c == null) continue;
                    newPermanent.getCounters(game).addCounter(c);
                }
            }
            if ((auraIds = (List)(creatureToAurasMap = (Map)exileData.get("Auras")).get(creatureId)) == null) continue;
            HashSet<Card> returningAuras = new HashSet<Card>();
            for (UUID auraId : auraIds) {
                Card auraCard = game.getCard(auraId);
                if (auraCard == null || !exileZone.contains((Object)auraId)) continue;
                returningAuras.add(auraCard);
                game.getState().setValue("attachTo:" + auraCard.getId(), (Object)newPermanent);
            }
            controller.moveCards(returningAuras, Zone.BATTLEFIELD, source, game, false, false, true, null);
            for (Card enchantment : returningAuras) {
                Permanent permanent = game.getPermanent(enchantment.getId());
                if (permanent == null) continue;
                newPermanent.addAttachment(permanent.getId(), source, game);
            }
        }
        game.getState().setValue(exileZoneId.toString() + "ExiledKeys", new ArrayList());
        return true;
    }
}

