/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.ActivatedManaAbilityImpl;
import mage.cards.t.TazriStalwartSurvivorManaEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TazriStalwartSurvivorManaAbility
extends ActivatedManaAbilityImpl {
    TazriStalwartSurvivorManaAbility() {
        super(Zone.BATTLEFIELD, (ManaEffect)new TazriStalwartSurvivorManaEffect(), (Cost)new TapSourceCost());
        this.condition = TazriStalwartSurvivorCondition.instance;
    }

    private TazriStalwartSurvivorManaAbility(TazriStalwartSurvivorManaAbility ability) {
        super((ActivatedManaAbilityImpl)ability);
    }

    public TazriStalwartSurvivorManaAbility copy() {
        return new TazriStalwartSurvivorManaAbility(this);
    }

    public String getRule() {
        return "{T}: Add one mana of any of this creature's colors. Spend this mana only to activate an ability of a creature. Activate only if this creature has another activated ability.";
    }

    private static enum TazriStalwartSurvivorCondition implements Condition
    {
        instance;


        public boolean apply(Game game, Ability source) {
            Permanent permanent = source.getSourcePermanentIfItStillExists(game);
            return permanent != null && permanent.getAbilities(game).stream().filter(Ability::isActivatedAbility).map(Ability::getOriginalId).anyMatch(abilityId -> !source.getOriginalId().equals(abilityId));
        }
    }
}

