/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Objects;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TeachingsOfTheArchaicsEffect
extends OneShotEffect {
    TeachingsOfTheArchaicsEffect() {
        super(Outcome.Benefit);
        this.staticText = "if an opponent has more cards in hand than you, draw two cards. Draw three cards instead if an opponent has at least four more cards in hand than you";
    }

    private TeachingsOfTheArchaicsEffect(TeachingsOfTheArchaicsEffect effect) {
        super((OneShotEffect)effect);
    }

    public TeachingsOfTheArchaicsEffect copy() {
        return new TeachingsOfTheArchaicsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int diff = game.getOpponents(source.getControllerId(), true).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getHand).mapToInt(Set::size).max().orElse(0);
        if ((diff -= player.getHand().size()) <= 0) {
            return false;
        }
        return player.drawCards(diff >= 4 ? 3 : 2, source, game) > 0;
    }
}

