/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TectonicHellionEffect
extends OneShotEffect {
    TectonicHellionEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player who controls the most lands sacrifices two lands";
    }

    private TectonicHellionEffect(TectonicHellionEffect effect) {
        super((OneShotEffect)effect);
    }

    public TectonicHellionEffect copy() {
        return new TectonicHellionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashMap landMap = new HashMap();
        game.getState().getPlayersInRange(source.getControllerId(), game).forEach(uuid -> landMap.put(uuid, game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND, uuid, source, game).size()));
        int max = (Integer)landMap.values().stream().max(Integer::compare).get();
        SacrificeEffect effect = new SacrificeEffect((FilterPermanent)StaticFilters.FILTER_LANDS, 2, "");
        game.getState().getPlayersInRange(source.getControllerId(), game).stream().filter(uuid -> landMap.getOrDefault(uuid, 0) == max).forEachOrdered(arg_0 -> TectonicHellionEffect.lambda$apply$2((Effect)effect, game, source, arg_0));
        return true;
    }

    private static /* synthetic */ void lambda$apply$2(Effect effect, Game game, Ability source, UUID uuid) {
        effect.setTargetPointer((TargetPointer)new FixedTarget(uuid, game));
        effect.apply(game, source);
    }
}

