/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class TeferiTemporalPilgrimEffect
extends OneShotEffect {
    TeferiTemporalPilgrimEffect() {
        super(Outcome.Removal);
        this.staticText = "Target opponent chooses a permanent they control and returns it to its owner's hand. Then they shuffle each nonland permanent they control into its owner's library.";
    }

    private TeferiTemporalPilgrimEffect(TeferiTemporalPilgrimEffect effect) {
        super((OneShotEffect)effect);
    }

    public TeferiTemporalPilgrimEffect copy() {
        return new TeferiTemporalPilgrimEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet toLibrary;
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        TargetControlledPermanent target = new TargetControlledPermanent();
        target.withNotTarget(true);
        opponent.chooseTarget(Outcome.ReturnToHand, (Target)target, source, game);
        Permanent toHand = game.getPermanent(target.getFirstTarget());
        if (toHand != null) {
            opponent.moveCards((Card)toHand, Zone.HAND, source, game);
            game.processAction();
        }
        if ((toLibrary = new HashSet(game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_NON_LAND, opponent.getId(), game))).isEmpty()) {
            return true;
        }
        HashSet<UUID> ownerIds = new HashSet<UUID>();
        for (Permanent permanent : toLibrary) {
            ownerIds.add(permanent.getOwnerId());
        }
        opponent.moveCards(toLibrary, Zone.LIBRARY, source, game);
        for (UUID ownerId : ownerIds) {
            Player owner = game.getPlayer(ownerId);
            if (owner == null) continue;
            owner.shuffleLibrary(source, game);
        }
        return true;
    }
}

