/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.events.GameEvent;

class TeferiTimelessVoyagerPhaseEffect
extends ContinuousRuleModifyingEffectImpl {
    private int castOnTurn = 0;
    private final MageObjectReference mor;

    TeferiTimelessVoyagerPhaseEffect(MageObjectReference mor) {
        super(Duration.Custom, Outcome.Neutral);
        this.mor = mor;
    }

    private TeferiTimelessVoyagerPhaseEffect(TeferiTimelessVoyagerPhaseEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
        this.castOnTurn = effect.castOnTurn;
        this.mor = effect.mor;
    }

    public TeferiTimelessVoyagerPhaseEffect copy() {
        return new TeferiTimelessVoyagerPhaseEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.castOnTurn = game.getTurnNum();
    }

    public boolean isInactive(Ability source, Game game) {
        if (this.castOnTurn != game.getTurnNum() && game.getPhase().getStep().getType() == PhaseStep.END_TURN) {
            return game.isActivePlayer(source.getControllerId());
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PHASE_IN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return this.mor.refersTo(event.getTargetId(), game);
    }
}

