/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

class TeferiWhoSlowsTheSunsetEffect
extends OneShotEffect {
    TeferiWhoSlowsTheSunsetEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose up to one target artifact, up to one target creature, and up to one target land. Untap the chosen permanents you control. Tap the chosen permanents you don't control.";
    }

    private TeferiWhoSlowsTheSunsetEffect(TeferiWhoSlowsTheSunsetEffect effect) {
        super((OneShotEffect)effect);
    }

    public TeferiWhoSlowsTheSunsetEffect copy() {
        return new TeferiWhoSlowsTheSunsetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Target target : source.getTargets()) {
            Permanent targetPermanent = game.getPermanent(target.getFirstTarget());
            if (targetPermanent == null) continue;
            if (targetPermanent.isControlledBy(source.getControllerId())) {
                targetPermanent.untap(game);
                continue;
            }
            targetPermanent.tap(source, game);
        }
        return true;
    }
}

