/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TeferisPuzzleBoxEffect
extends OneShotEffect {
    TeferisPuzzleBoxEffect() {
        super(Outcome.Neutral);
        this.staticText = "that player puts the cards in their hand on the bottom of their library in any order, then draws that many cards";
    }

    private TeferisPuzzleBoxEffect(TeferisPuzzleBoxEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            int count = player.getHand().size();
            player.putCardsOnBottomOfLibrary(player.getHand(), game, source, true);
            player.drawCards(count, source, game);
        }
        return true;
    }

    public TeferisPuzzleBoxEffect copy() {
        return new TeferisPuzzleBoxEffect(this);
    }
}

