/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PhaseOutAllEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TeferisRealmEffect
extends OneShotEffect {
    private static final String ARTIFACT = "Artifact";
    private static final String CREATURE = "Creature";
    private static final String LAND = "Land";
    private static final String NON_AURA_ENCHANTMENT = "Non-Aura enchantment";
    private static final Set<String> choices = new LinkedHashSet<String>();

    public TeferisRealmEffect() {
        super(Outcome.Detriment);
        this.staticText = "that player chooses artifact, creature, land, or non-Aura enchantment. All nontoken permanents of that type phase out";
    }

    private TeferisRealmEffect(TeferisRealmEffect effect) {
        super((OneShotEffect)effect);
    }

    public TeferisRealmEffect copy() {
        return new TeferisRealmEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (player != null && controller != null) {
            ChoiceImpl choiceImpl = new ChoiceImpl(true);
            choiceImpl.setMessage("Phase out which kind of permanents?");
            choiceImpl.setChoices(choices);
            if (!player.choose(this.outcome, (Choice)choiceImpl, game)) {
                return false;
            }
            String chosenType = choiceImpl.getChoice();
            FilterPermanent filter = new FilterPermanent();
            filter.add((Predicate)TokenPredicate.FALSE);
            switch (chosenType) {
                case "Artifact": {
                    filter.add((Predicate)CardType.ARTIFACT.getPredicate());
                    break;
                }
                case "Creature": {
                    filter.add((Predicate)CardType.CREATURE.getPredicate());
                    break;
                }
                case "Land": {
                    filter.add((Predicate)CardType.LAND.getPredicate());
                    break;
                }
                case "Non-Aura enchantment": {
                    filter.add((Predicate)CardType.ENCHANTMENT.getPredicate());
                    filter.add(Predicates.not((Predicate)SubType.AURA.getPredicate()));
                    break;
                }
                default: {
                    return false;
                }
            }
            game.informPlayers(player.getLogName() + " chooses " + chosenType + "s to phase out");
            ArrayList<UUID> permIds = new ArrayList<UUID>();
            for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, controller.getId(), game)) {
                permIds.add(permanent.getId());
            }
            return new PhaseOutAllEffect(permIds).apply(game, source);
        }
        return false;
    }

    static {
        choices.add(ARTIFACT);
        choices.add(CREATURE);
        choices.add(LAND);
        choices.add(NON_AURA_ENCHANTMENT);
    }
}

