/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.t.TeferisTimeTwistReturnEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TeferisTimeTwistEffect
extends OneShotEffect {
    TeferisTimeTwistEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile target permanent you control. Return that card to the battlefield under its owner's control at the beginning of the next end step. If it enters the battlefield as a creature, it enters with an additional +1/+1 counter on it.";
    }

    private TeferisTimeTwistEffect(TeferisTimeTwistEffect effect) {
        super((OneShotEffect)effect);
    }

    public TeferisTimeTwistEffect copy() {
        return new TeferisTimeTwistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        Player player = game.getPlayer(source.getControllerId());
        if (permanent == null || player == null) {
            return false;
        }
        TeferisTimeTwistReturnEffect effect = new TeferisTimeTwistReturnEffect(new MageObjectReference(permanent.getId(), permanent.getZoneChangeCounter(game) + 1, game));
        if (!player.moveCards((Card)permanent, Zone.EXILED, source, game)) {
            return false;
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect), source);
        return true;
    }
}

