/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class TeferisTimeTwistReturnEffect
extends OneShotEffect {
    private final MageObjectReference mor;

    TeferisTimeTwistReturnEffect(MageObjectReference mor) {
        super(Outcome.Benefit);
        this.staticText = "return the exiled card to the battlefield";
        this.mor = mor;
    }

    private TeferisTimeTwistReturnEffect(TeferisTimeTwistReturnEffect effect) {
        super((OneShotEffect)effect);
        this.mor = effect.mor;
    }

    public TeferisTimeTwistReturnEffect copy() {
        return new TeferisTimeTwistReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = this.mor.getCard(game);
        if (card == null) {
            return false;
        }
        Player player = game.getPlayer(card.getOwnerId());
        if (player == null) {
            return false;
        }
        if (!player.moveCards(card, Zone.BATTLEFIELD, source, game)) {
            return true;
        }
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent != null && permanent.isCreature(game)) {
            permanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
        }
        return true;
    }
}

