/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class TempOfTheDamnedEffect
extends OneShotEffect {
    TempOfTheDamnedEffect() {
        super(Outcome.Neutral);
        this.staticText = "roll a six-sided die. {this} enters with a number of funk counters on it equal to the result";
    }

    private TempOfTheDamnedEffect(TempOfTheDamnedEffect effect) {
        super((OneShotEffect)effect);
    }

    public TempOfTheDamnedEffect copy() {
        return new TempOfTheDamnedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            return new AddCountersSourceEffect(CounterType.FUNK.createInstance(controller.rollDice(Outcome.Benefit, source, game, 6))).apply(game, source);
        }
        return false;
    }
}

