/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.events.PreventDamageEvent;
import mage.game.events.PreventedDamageEvent;
import mage.game.permanent.Permanent;

class TemperPreventDamageTargetEffect
extends PreventionEffectImpl {
    private int amount;
    private final DynamicValue dVal;
    private boolean initialized;

    public TemperPreventDamageTargetEffect(DynamicValue dVal, Duration duration) {
        super(duration);
        this.initialized = false;
        this.dVal = dVal;
        this.staticText = "Prevent the next X damage that would be dealt to target creature this turn. For each 1 damage prevented this way, put a +1/+1 counter on that creature";
    }

    private TemperPreventDamageTargetEffect(TemperPreventDamageTargetEffect effect) {
        super((PreventionEffectImpl)effect);
        this.amount = effect.amount;
        this.dVal = effect.dVal;
        this.initialized = effect.initialized;
    }

    public TemperPreventDamageTargetEffect copy() {
        return new TemperPreventDamageTargetEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        PreventDamageEvent preventEvent;
        if (!this.initialized) {
            this.amount = this.dVal.calculate(game, source, (Effect)this);
            this.initialized = true;
        }
        if (!game.replaceEvent((GameEvent)(preventEvent = new PreventDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), event.getAmount(), ((DamageEvent)event).isCombatDamage())))) {
            Permanent targetPermanent;
            int damage;
            int prevented = 0;
            if (event.getAmount() >= this.amount) {
                damage = this.amount;
                event.setAmount(event.getAmount() - this.amount);
                this.used = true;
                game.fireEvent((GameEvent)new PreventedDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), damage));
                prevented = damage;
            } else {
                damage = event.getAmount();
                event.setAmount(0);
                this.amount -= damage;
                game.fireEvent((GameEvent)new PreventedDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), damage));
                prevented = damage;
            }
            if (prevented > 0 && (targetPermanent = game.getPermanent(source.getTargets().getFirstTarget())) != null) {
                targetPermanent.addCounters(CounterType.P1P1.createInstance(prevented), source.getControllerId(), source, game);
                game.informPlayers("Temper: Prevented " + prevented + " damage ");
                game.informPlayers("Temper: Adding " + prevented + " +1/+1 counters to " + targetPermanent.getName());
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!this.used && super.applies(event, source, game)) {
            return source.getTargets().getFirstTarget().equals(event.getTargetId());
        }
        return false;
    }
}

