/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class TemporalApertureTopCardCastEffect
extends AsThoughEffectImpl {
    private final Card card;

    public TemporalApertureTopCardCastEffect(Card card) {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfTurn, Outcome.Benefit);
        this.card = card;
        this.staticText = "Until end of turn, for as long as that card is on top of your library, you may cast it without paying its mana costs";
    }

    private TemporalApertureTopCardCastEffect(TemporalApertureTopCardCastEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.card = effect.card;
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public TemporalApertureTopCardCastEffect copy() {
        return new TemporalApertureTopCardCastEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Player controller;
        Card objectCard;
        if (affectedControllerId.equals(source.getControllerId()) && (objectCard = game.getCard(objectId)) != null && (controller = game.getPlayer(affectedControllerId)) != null && game.getState().getZone(objectId) == Zone.LIBRARY && controller.getLibrary().getFromTop(game).equals(this.card) && objectCard == this.card && (objectCard.getSpellAbility() != null || objectCard.isLand(game))) {
            this.allowCardToPlayWithoutMana(objectId, source, affectedControllerId, game);
            return true;
        }
        return false;
    }
}

