/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TemporalCascadeDrawEffect
extends OneShotEffect {
    TemporalCascadeDrawEffect() {
        super(Outcome.Neutral);
        this.staticText = "Each player draws seven cards";
    }

    private TemporalCascadeDrawEffect(TemporalCascadeDrawEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player sourcePlayer = game.getPlayer(source.getControllerId());
        game.getState().handleSimultaneousEvent(game);
        for (UUID playerId : game.getState().getPlayersInRange(sourcePlayer.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.drawCards(7, source, game);
        }
        return true;
    }

    public TemporalCascadeDrawEffect copy() {
        return new TemporalCascadeDrawEffect(this);
    }
}

