/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TemporalCleansingEffect
extends OneShotEffect {
    TemporalCleansingEffect() {
        super(Outcome.Benefit);
        this.staticText = "the owner of target nonland permanent puts it into their library second from the top or on the bottom";
    }

    private TemporalCleansingEffect(TemporalCleansingEffect effect) {
        super((OneShotEffect)effect);
    }

    public TemporalCleansingEffect copy() {
        return new TemporalCleansingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getOwnerId());
        if (player == null) {
            return false;
        }
        if (player.chooseUse(this.outcome, "Put " + permanent.getIdName() + " second from the top or on the bottom?", null, "Second from top", "Bottom", source, game)) {
            return player.putCardOnTopXOfLibrary((Card)permanent, game, source, 2, true);
        }
        return player.putCardsOnBottomOfLibrary((Card)permanent, game, source);
    }
}

