/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class TemporalExtortionCounterSourceEffect
extends OneShotEffect {
    TemporalExtortionCounterSourceEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "any player may pay half their life, rounded up. If a player does, counter {this}";
    }

    private TemporalExtortionCounterSourceEffect(TemporalExtortionCounterSourceEffect effect) {
        super((OneShotEffect)effect);
    }

    public TemporalExtortionCounterSourceEffect copy() {
        return new TemporalExtortionCounterSourceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject != null) {
            for (UUID playerId : game.getState().getPlayerList(source.getControllerId())) {
                Player player = game.getPlayer(playerId);
                if (player == null || !player.chooseUse(this.outcome, "Pay half your life, rounded up to counter " + sourceObject.getIdName() + '?', source, game)) continue;
                int amount = (int)Math.ceil((float)player.getLife() / 2.0f);
                player.loseLife(amount, game, source, false);
                game.informPlayers(player.getLogName() + " pays half their life, rounded up to counter " + sourceObject.getIdName() + '.');
                Spell spell = game.getStack().getSpell(source.getSourceId());
                if (spell == null) continue;
                game.getStack().counter(spell.getId(), source, game);
            }
            return true;
        }
        return false;
    }
}

