/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.players.PlayerList;

class TemptWithReflectionsEffect
extends OneShotEffect {
    TemptWithReflectionsEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "<i>Tempting offer</i> &mdash; Choose target creature you control. Create a token that's a copy of that creature. Each opponent may create a token that's a copy of that creature. For each opponent who does, create a token that's a copy of that creature";
    }

    private TemptWithReflectionsEffect(TemptWithReflectionsEffect effect) {
        super((OneShotEffect)effect);
    }

    public TemptWithReflectionsEffect copy() {
        return new TemptWithReflectionsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent != null) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
            effect.setTargetPointer(this.getTargetPointer().copy());
            effect.apply(game, source);
            HashSet<UUID> playersSaidYes = new HashSet<UUID>();
            PlayerList playerList = game.getPlayerList().copy();
            playerList.setCurrent((Object)game.getActivePlayerId());
            Player player = game.getPlayer(game.getActivePlayerId());
            do {
                String decision;
                if (!game.getOpponents(source.getControllerId()).contains(player.getId())) continue;
                if (player.chooseUse(this.outcome, "Create a copy of target creature for you?", source, game)) {
                    playersSaidYes.add(player.getId());
                    decision = " chooses to copy ";
                } else {
                    decision = " won't copy ";
                }
                game.informPlayers(player.getLogName() + decision + permanent.getName());
            } while ((player = playerList.getNext(game, false)) != null && !player.getId().equals(game.getActivePlayerId()));
            for (UUID playerId : playersSaidYes) {
                effect = new CreateTokenCopyTargetEffect(playerId);
                effect.setTargetPointer(this.getTargetPointer().copy());
                effect.apply(game, source);
                effect = new CreateTokenCopyTargetEffect();
                effect.setTargetPointer(this.getTargetPointer().copy());
                effect.apply(game, source);
            }
            return true;
        }
        return false;
    }
}

