/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.Elemental11HasteToken;
import mage.players.Player;
import mage.util.CardUtil;

class TemptWithVengeanceEffect
extends OneShotEffect {
    TemptWithVengeanceEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "<i>Tempting offer</i> &mdash; Create X 1/1 red Elemental creature tokens with haste. Each opponent may create X 1/1 red Elemental creature tokens with haste. For each opponent who does, create X 1/1 red Elemental creature tokens with haste";
    }

    private TemptWithVengeanceEffect(TemptWithVengeanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public TemptWithVengeanceEffect copy() {
        return new TemptWithVengeanceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (controller != null && xValue > 0) {
            Elemental11HasteToken tokenCopy = new Elemental11HasteToken();
            tokenCopy.putOntoBattlefield(xValue, game, source, source.getControllerId(), false, false);
            int opponentsAddedTokens = 0;
            for (UUID playerId : game.getOpponents(controller.getId())) {
                Player opponent = game.getPlayer(playerId);
                if (opponent == null || !opponent.chooseUse(this.outcome, "Create " + xValue + " Elemental tokens?", source, game)) continue;
                opponentsAddedTokens += xValue;
                tokenCopy.putOntoBattlefield(xValue, game, source, playerId, false, false);
            }
            if (opponentsAddedTokens > 0) {
                tokenCopy.putOntoBattlefield(opponentsAddedTokens, game, source, source.getControllerId(), false, false);
            }
            return true;
        }
        return false;
    }
}

