/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.util.CardUtil;

class TemurBattlecrierEffect
extends CostModificationEffectImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();
    private static final Hint hint;

    public static Hint getHint() {
        return hint;
    }

    TemurBattlecrierEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "during your turn, spells you cast cost {1} less to cast for each creature you control with power 4 or greater";
    }

    private TemurBattlecrierEffect(TemurBattlecrierEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Ability spellAbility = abilityToModify;
        if (spellAbility == null) {
            return false;
        }
        int amount = game.getBattlefield().count(filter, source.getControllerId(), source, game);
        if (amount > 0) {
            CardUtil.reduceCost((Ability)spellAbility, (int)amount);
        }
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!(abilityToModify instanceof SpellAbility && abilityToModify.isControlledBy(source.getControllerId()) && game.isActivePlayer(source.getControllerId()))) {
            return false;
        }
        Card spellCard = ((SpellAbility)abilityToModify).getCharacteristics(game);
        return spellCard != null;
    }

    public TemurBattlecrierEffect copy() {
        return new TemurBattlecrierEffect(this);
    }

    static {
        filter.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 3));
        hint = new ValueHint("Creatures you control with power 4 or greater", (DynamicValue)new PermanentsOnBattlefieldCount(filter));
    }
}

