/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CounterUnlessPaysEffect;
import mage.abilities.effects.common.FightTargetsEffect;
import mage.abilities.effects.common.combat.CantBlockAllEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.TargetSpell;
import mage.target.common.TargetControlledCreaturePermanent;

public final class TemurCharm
extends CardImpl {
    private static final FilterCreaturePermanent filterCantBlock = new FilterCreaturePermanent("Creatures with power 3 or less");

    public TemurCharm(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{G}{U}{R}");
        BoostTargetEffect effect = new BoostTargetEffect(1, 1, Duration.EndOfTurn);
        this.getSpellAbility().addEffect((Effect)effect);
        effect = new FightTargetsEffect();
        effect.setText("It fights target creature you don't control");
        this.getSpellAbility().addEffect((Effect)effect);
        this.getSpellAbility().addTarget((Target)new TargetControlledCreaturePermanent());
        TargetPermanent target = new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CREATURE_YOU_DONT_CONTROL);
        this.getSpellAbility().addTarget((Target)target);
        Mode mode = new Mode((Effect)new CounterUnlessPaysEffect((Cost)new GenericManaCost(3)));
        mode.addTarget((Target)new TargetSpell());
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new CantBlockAllEffect(filterCantBlock, Duration.EndOfTurn));
        this.getSpellAbility().addMode(mode);
    }

    private TemurCharm(TemurCharm card) {
        super((CardImpl)card);
    }

    public TemurCharm copy() {
        return new TemurCharm(this);
    }

    static {
        filterCantBlock.add((Predicate)new PowerPredicate(ComparisonType.FEWER_THAN, 4));
    }
}

