/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Set;
import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TenuousTruceAttackTriggeredAbility
extends TriggeredAbilityImpl {
    TenuousTruceAttackTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new SacrificeSourceEffect(), false);
        this.setTriggerPhrase("When you attack enchanted opponent or a planeswalker they control or when they attack you or a planeswalker you control, ");
    }

    private TenuousTruceAttackTriggeredAbility(TenuousTruceAttackTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent tenuousTruce = game.getPermanent(this.getSourceId());
        Player controller = game.getPlayer(this.getControllerId());
        Player attacker = game.getPlayer(game.getCombat().getAttackingPlayerId());
        if (tenuousTruce == null || controller == null || attacker == null) {
            return false;
        }
        Player enchantedPlayer = game.getPlayer(tenuousTruce.getAttachedTo());
        if (enchantedPlayer == null) {
            return false;
        }
        Set defenderIds = game.getCombat().getPlayerDefenders(game, true);
        if (controller.equals(attacker)) {
            return TenuousTruceAttackTriggeredAbility.playerOneAttackingPlayerBOrTheirPlaneswalker(controller.getId(), enchantedPlayer.getId(), defenderIds, game);
        }
        if (enchantedPlayer.equals(attacker)) {
            return TenuousTruceAttackTriggeredAbility.playerOneAttackingPlayerBOrTheirPlaneswalker(enchantedPlayer.getId(), controller.getId(), defenderIds, game);
        }
        return false;
    }

    private static boolean playerOneAttackingPlayerBOrTheirPlaneswalker(UUID playerAId, UUID playerBId, Set<UUID> defenderIds, Game game) {
        if (defenderIds.contains(playerBId)) {
            return true;
        }
        for (UUID defenderId : defenderIds) {
            Permanent perm = game.getPermanent(defenderId);
            if (perm == null || !perm.getOwnerId().equals(playerBId)) continue;
            return true;
        }
        return false;
    }

    public TenuousTruceAttackTriggeredAbility copy() {
        return new TenuousTruceAttackTriggeredAbility(this);
    }
}

